/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: PlanHints.java 627367 2008-02-13 12:03:30Z maxberger $ */
 
package org.apache.fop.plan;

/**
 * This interface defines some constants for use in the plan package.
 */
public interface PlanHints {
    
    /** Border attribute */
    public static final String PLAN_BORDER = "border";
    /** Legend attribute */
    public static final String PLAN_LEGEND = "legend";
    /** Font family attribute */
    public static final String FONT_FAMILY = "font-family";
    /** Font size attribute */
    public static final String FONT_SIZE = "font-size";
    /** Legent type attribute */
    public static final String LEGEND_TYPE = "legendType";
    /** Locale attribute */
    public static final String LOCALE = "locale";
    /** Label type attribute */
    public static final String LABEL_TYPE = "labelType";
    /** Label font size attribute */
    public static final String LABEL_FONT_SIZE = "labelFontSize";
    /** Label font attribute */
    public static final String LABEL_FONT = "labelFont";

}
