#   Menubar and Toolbar beside each other - Epiphany Extension
#   Copyright (C) 2006  Stefan Stuhr
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


import gtk
import epiphany

def attach_window(window):
	toolbar = window.get_toolbar()
	vbox = toolbar.parent
	if not isinstance(vbox, gtk.VBox):
		return

	children = vbox.get_children()
	if len(children) != 2 or (not isinstance(children[0], gtk.MenuBar)) or children[1] != toolbar:
		return

	hbox = gtk.HBox()
	vbox.pack_start(hbox, False, True, 0)

	window._mbatb_top_packings = []

	for index, widget in enumerate(children):
		is_visible = widget.get_property("visible")
		gtk.Widget.hide(widget)

		window._mbatb_top_packings.append(vbox.query_child_packing(widget))
		vbox.remove(widget)

		hbox.pack_start(widget, index, True, 0)

		if is_visible:
			gtk.Widget.show(widget)

	hbox.show()

	window._mbatb_top_hbox = hbox

def detach_window(window):
	if not (hasattr(window, "_mbatb_top_hbox") and hasattr(window, "_mbatb_top_packings")):
		return

	hbox = window._mbatb_top_hbox
	vbox = hbox.parent

	for widget, packing in zip(hbox.get_children(), window._mbatb_top_packings):
		is_visible = widget.get_property("visible")
		gtk.Widget.hide(widget)

		hbox.remove(widget)

		vbox.pack_start(widget)
		vbox.set_child_packing(widget, *packing)

		if is_visible:
			gtk.Widget.show(widget)

	hbox.hide()
	vbox.remove(hbox)
	hbox.destroy()

	delattr(window, "_mbatb_top_hbox")
	delattr(window, "_mbatb_top_packings")
