// Written by Aecio F. Neto (afn@harvest.com.br) - Harvest Consultoria (http://www.harvest.com.br)
// Additions by Nerijus Baliunas (nerijus@users.sourceforge.net)

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "autoconf/platform.h"
#include "VirusEngine.hpp"
#include "OptionContainer.hpp"
#include <unistd.h>
#include <fstream>

#ifdef __CLAMDSCAN
#include "ClamDScan.hpp"
#endif

#ifdef __CLAMAV
#include "ClamAV.hpp"
#include <clamav.h>
extern ClamAV clamav;
#endif

#ifdef __KAV
#include "KAV.hpp"
extern KAV kav;
#endif

extern OptionContainer o;

VirusEngine::VirusEngine()
:virname(0), strError(0) {}
// virname - holds the virus name, if found
// strError - holds the error message text from the engine library

VirusEngine::~VirusEngine() {
// delete statements removed according to Alexander Marx mem leak patch
}

int VirusEngine::scan(char* tempFileName) {

    int ret = 0;

    if (o.virus_engine == 1) { // ClamAV
#ifdef __CLAMAV
	ret = clamav.scanFile(tempFileName);
	virname = clamav.virname;
		
	if (ret == CL_CLEAN)
	    ret = AV_CLEAN;
	else if (ret == CL_VIRUS)
	    ret = AV_VIRUS;
	else {
	    strError = cl_strerror(ret);
	}
#endif
    }
    else if (o.virus_engine == 2) { // KAV
#ifdef __KAV
	ret = kav.scanFile(tempFileName);
	virname = kav.virname;

	if (ret == KAV_STATUS_CLEAN || ret == KAV_STATUS_CORRUPTED_FOUND)
	    ret = AV_CLEAN;
	else {
	    //if (ret == KAV_STATUS_VIRUSES_FOUND || ret == KAV_STATUS_SUSPICIOUS_FOUND
	    //|| ret == KAV_STATUS_CORRUPTED_VIRUSES_FOUND)
	    ret = AV_VIRUS;
	}
#endif
    }
    else if (o.virus_engine == 3) { // ClamDScan
#ifdef __CLAMDSCAN
	ClamDScan clamdscan;
	ret = clamdscan.scanFile(tempFileName);
	virname = clamdscan.virname;
		
	if (ret == CL_CLEAN)
	    ret = AV_CLEAN;
	else if (ret == CL_VIRUS)
	    ret = AV_VIRUS;
	else {
	    strError = clamdscan.errorMsg;
	}
#endif
    }
    else {
	virname = "";
	ret = AV_CLEAN;
    }

    return ret;
}
