# Cogito 'cg' bash completion.
#
# Copyright (c) Ben Clifford, 2005
# Copyright (c) Paolo Giarrusso, 2005
#
# The master version is available at:
#	http://www.hawaga.org.uk/gitcompletion.git

bashdefault="-o bashdefault"
default="-o default"

__cg_branches()
{
    REVERTGLOB=`shopt -p nullglob`
    shopt -s nullglob
    if [ -n ".git/branches/*" ] ; then
        for i in $(echo .git/branches/*); do
            echo ${i#.git/branches/}
        done
    fi
    $REVERTGLOB
}

__cg_cmdlist()
{
	(cg help && cg help tag && cg help branch && cg help admin) | grep --regexp "cg-[^ ]* " | sed 's/^.*\cg-\([^ ]*\) .*$/\1/' | grep -v COMMAND

}

_cg ()
{
    local cur cmd opts
    cur=${COMP_WORDS[COMP_CWORD]}
    COMPREPLY=()
    if [ $COMP_CWORD -eq 1 ]; then
	COMPREPLY=( $(compgen -W "$(__cg_cmdlist)" -- $cur) )
    else
	local cmd=${COMP_WORDS[1]}
	local prev=${COMP_WORDS[COMP_CWORD-1]}
	local o_help="-h --help"
	local o_branch="-b --branch"
	case $cmd in
	    add)
	    # cg-add [-N] [-r] file...
	    # XXX here could generate list of files and dirs excluding .git
	    opts="-N -r"
	    COMPREPLY=( $(compgen -d -f -W "${opts}" -- $cur ) )
	    ;;

	    branch-add)
	    # cg branch-add BRANCH_NAME LOCATION
            # nothing special for NEWBRANCH, but LOCATION can
	    # be completed
            if [ "$COMP_CWORD" = "3" ]; then 
		COMPREPLY=( $(compgen -W "$(__git_repo_urls)" -- $cur ) )
	    fi
	    ;;

	    clean)
	    # Usage: cg-clean [-d] [-D] [-q] [-x]
	    opts="-d -D -q -x"
	    COMPREPLY=( $(compgen -W "${opts}" -- $cur ) )
	    ;;

	    help)
	    opts="-c"
	    COMPREPLY=( $(compgen -W "$(__cg_cmdlist) ${opts}" -- $cur) )
	    ;;

	    push)
	    # cg-push [BRANCH_NAME] [-t TAG]
	    opts="-t" 
	    if [ "$prev" = "-t" ]; then 
	        COMPREPLY=( $(compgen -W "$(__git_tags)" -- $cur) )
	    else
	        COMPREPLY=( $(compgen -W "${opts} $(__cg_branches)" -- $cur) )
	    fi
	    ;;

	    merge)
	    # cg-merge [-c] [-b BASE_COMMIT] [BRANCH_NAME]
	    opts="-c -b" 
	    if [ "$prev" = "-b" ]; then 
	        COMPREPLY=( $(compgen -W "$(__git_refs)" -- $cur) )
	    else
	        COMPREPLY=( $(compgen -W "${opts} $(__git_refs)" -- $cur) )
	    fi
	    ;;

	    commit) 
            # cg-commit [-m MESSAGE]... [-C] [-e | -E] [-c COMMIT_ID] [FILE]
	    opts="-m -C -e -E -c" 
	    if [ "$prev" = "-m" ]; then 
		COMPREPLY="\"\""
	    elif [ "$prev" = "-c" ]; then 
		COMPREPLY=( $(compgen -W "$(__git_refs)" -- $cur) )
	    else
		COMPREPLY=( $(compgen -f -W "${opts} " -- $cur) )
	    fi
	    ;;

	    diff)
            # cg-diff [-c] [-m] [-s] [-p] [-r FROM_ID[:TO_ID]] [FILE]...
            opts="-c -m -s -p -r"
	    if [ "$prev" = "-r" ]; then 
            # TODO need some kinkiness to handle -r FROM:TO completion
		COMPREPLY=( $(compgen -W "$(__git_refs)" -- $cur) )
	    else
		COMPREPLY=( $(compgen -f -W "${opts} " -- $cur) )
	    fi
	    ;;

	    log)
            opts="-c -f -r -d -m -s -u --summary"
	    if [ "$prev" = "-r" ]; then 
            # TODO need some kinkiness to handle -r FROM:TO completion
		COMPREPLY=( $(compgen -W "$(__git_refs)" -- $cur) )
	    elif [ "$prev" = "-d" ]; then 
            # TODO what are good completions if any?
		COMPREPLY=( "yesterday" )
	    elif [ "$prev" = "-u" ]; then 
            # useful when the authors/committers have accounts on localhost?
		COMPREPLY=( $(compgen -u -- $cur) )
	    else
		COMPREPLY=( $(compgen -f -W "${opts} " -- $cur) )
	    fi
	    ;;
	    version)
            # no options
            COMPREPLY=()
	    ;;
	    switch)
	    # Usage: cg-switch [-f] [-n] [-r COMMIT_ID] BRANCH
	    opts="-f -n -r"  # TODO -r 
	    COMPREPLY=( $(compgen -W "${opts} $(__git_heads)" -- $cur) )
	    ;;


	    *)
	    COMPREPLY=( $(compgen $default -W "${o_help}" -f -- $cur) )
	    ;;
	esac
    fi
}

complete $default -F _cg cg 


# These are commands still TODO:

#	cg-clone           Clone a remote GIT repository.
#	cg-export          Exports a particular revision from a GIT repository.
#	cg-fetch           Fetch changes from a remote branch to the local GIT repository.
#	cg-init            Initialize a GIT repository.
#	cg-mkpatch         Make a patch from one or several commits.
#	cg-object-id       Get SHA1 ID of commit or tree associated with given ID or HEAD.
#	cg-patch           Apply a diff generated by cg-diff.
#	cg-reset           Resets the state of the working tree.
#	cg-restore         Restore files in the working tree to state at the given/last commit.
#	cg-rm              Remove files from a GIT repository.
#	cg-seek            Seek the working tree to a given commit.
#	cg-status          Show status of your working tree.
#	cg-update          Pull and merge changes from a branch to the local repository.


# vi: set ft=sh sw=4:

