(in-package :pdf)

#-lispworks
(defvar *x11-colors*
  '(("LightGreen" 144 238 144)
    ("light green" 144 238 144)
    ("DarkRed" 139 0 0)
    ("dark red" 139 0 0)
    ("DarkMagenta" 139 0 139)
    ("dark magenta" 139 0 139)
    ("DarkCyan" 0 139 139)
    ("dark cyan" 0 139 139)
    ("DarkBlue" 0 0 139)
    ("dark blue" 0 0 139)
    ("DarkGray" 169 169 169)
    ("dark gray" 169 169 169)
    ("DarkGrey" 169 169 169)
    ("dark grey" 169 169 169)
    ("grey100" 255 255 255)
    ("gray100" 255 255 255)
    ("grey99" 252 252 252)
    ("gray99" 252 252 252)
    ("grey98" 250 250 250)
    ("gray98" 250 250 250)
    ("grey97" 247 247 247)
    ("gray97" 247 247 247)
    ("grey96" 245 245 245)
    ("gray96" 245 245 245)
    ("grey95" 242 242 242)
    ("gray95" 242 242 242)
    ("grey94" 240 240 240)
    ("gray94" 240 240 240)
    ("grey93" 237 237 237)
    ("gray93" 237 237 237)
    ("grey92" 235 235 235)
    ("gray92" 235 235 235)
    ("grey91" 232 232 232)
    ("gray91" 232 232 232)
    ("grey90" 229 229 229)
    ("gray90" 229 229 229)
    ("grey89" 227 227 227)
    ("gray89" 227 227 227)
    ("grey88" 224 224 224)
    ("gray88" 224 224 224)
    ("grey87" 222 222 222)
    ("gray87" 222 222 222)
    ("grey86" 219 219 219)
    ("gray86" 219 219 219)
    ("grey85" 217 217 217)
    ("gray85" 217 217 217)
    ("grey84" 214 214 214)
    ("gray84" 214 214 214)
    ("grey83" 212 212 212)
    ("gray83" 212 212 212)
    ("grey82" 209 209 209)
    ("gray82" 209 209 209)
    ("grey81" 207 207 207)
    ("gray81" 207 207 207)
    ("grey80" 204 204 204)
    ("gray80" 204 204 204)
    ("grey79" 201 201 201)
    ("gray79" 201 201 201)
    ("grey78" 199 199 199)
    ("gray78" 199 199 199)
    ("grey77" 196 196 196)
    ("gray77" 196 196 196)
    ("grey76" 194 194 194)
    ("gray76" 194 194 194)
    ("grey75" 191 191 191)
    ("gray75" 191 191 191)
    ("grey74" 189 189 189)
    ("gray74" 189 189 189)
    ("grey73" 186 186 186)
    ("gray73" 186 186 186)
    ("grey72" 184 184 184)
    ("gray72" 184 184 184)
    ("grey71" 181 181 181)
    ("gray71" 181 181 181)
    ("grey70" 179 179 179)
    ("gray70" 179 179 179)
    ("grey69" 176 176 176)
    ("gray69" 176 176 176)
    ("grey68" 173 173 173)
    ("gray68" 173 173 173)
    ("grey67" 171 171 171)
    ("gray67" 171 171 171)
    ("grey66" 168 168 168)
    ("gray66" 168 168 168)
    ("grey65" 166 166 166)
    ("gray65" 166 166 166)
    ("grey64" 163 163 163)
    ("gray64" 163 163 163)
    ("grey63" 161 161 161)
    ("gray63" 161 161 161)
    ("grey62" 158 158 158)
    ("gray62" 158 158 158)
    ("grey61" 156 156 156)
    ("gray61" 156 156 156)
    ("grey60" 153 153 153)
    ("gray60" 153 153 153)
    ("grey59" 150 150 150)
    ("gray59" 150 150 150)
    ("grey58" 148 148 148)
    ("gray58" 148 148 148)
    ("grey57" 145 145 145)
    ("gray57" 145 145 145)
    ("grey56" 143 143 143)
    ("gray56" 143 143 143)
    ("grey55" 140 140 140)
    ("gray55" 140 140 140)
    ("grey54" 138 138 138)
    ("gray54" 138 138 138)
    ("grey53" 135 135 135)
    ("gray53" 135 135 135)
    ("grey52" 133 133 133)
    ("gray52" 133 133 133)
    ("grey51" 130 130 130)
    ("gray51" 130 130 130)
    ("grey50" 127 127 127)
    ("gray50" 127 127 127)
    ("grey49" 125 125 125)
    ("gray49" 125 125 125)
    ("grey48" 122 122 122)
    ("gray48" 122 122 122)
    ("grey47" 120 120 120)
    ("gray47" 120 120 120)
    ("grey46" 117 117 117)
    ("gray46" 117 117 117)
    ("grey45" 115 115 115)
    ("gray45" 115 115 115)
    ("grey44" 112 112 112)
    ("gray44" 112 112 112)
    ("grey43" 110 110 110)
    ("gray43" 110 110 110)
    ("grey42" 107 107 107)
    ("gray42" 107 107 107)
    ("grey41" 105 105 105)
    ("gray41" 105 105 105)
    ("grey40" 102 102 102)
    ("gray40" 102 102 102)
    ("grey39" 99 99 99)
    ("gray39" 99 99 99)
    ("grey38" 97 97 97)
    ("gray38" 97 97 97)
    ("grey37" 94 94 94)
    ("gray37" 94 94 94)
    ("grey36" 92 92 92)
    ("gray36" 92 92 92)
    ("grey35" 89 89 89)
    ("gray35" 89 89 89)
    ("grey34" 87 87 87)
    ("gray34" 87 87 87)
    ("grey33" 84 84 84)
    ("gray33" 84 84 84)
    ("grey32" 82 82 82)
    ("gray32" 82 82 82)
    ("grey31" 79 79 79)
    ("gray31" 79 79 79)
    ("grey30" 77 77 77)
    ("gray30" 77 77 77)
    ("grey29" 74 74 74)
    ("gray29" 74 74 74)
    ("grey28" 71 71 71)
    ("gray28" 71 71 71)
    ("grey27" 69 69 69)
    ("gray27" 69 69 69)
    ("grey26" 66 66 66)
    ("gray26" 66 66 66)
    ("grey25" 64 64 64)
    ("gray25" 64 64 64)
    ("grey24" 61 61 61)
    ("gray24" 61 61 61)
    ("grey23" 59 59 59)
    ("gray23" 59 59 59)
    ("grey22" 56 56 56)
    ("gray22" 56 56 56)
    ("grey21" 54 54 54)
    ("gray21" 54 54 54)
    ("grey20" 51 51 51)
    ("gray20" 51 51 51)
    ("grey19" 48 48 48)
    ("gray19" 48 48 48)
    ("grey18" 46 46 46)
    ("gray18" 46 46 46)
    ("grey17" 43 43 43)
    ("gray17" 43 43 43)
    ("grey16" 41 41 41)
    ("gray16" 41 41 41)
    ("grey15" 38 38 38)
    ("gray15" 38 38 38)
    ("grey14" 36 36 36)
    ("gray14" 36 36 36)
    ("grey13" 33 33 33)
    ("gray13" 33 33 33)
    ("grey12" 31 31 31)
    ("gray12" 31 31 31)
    ("grey11" 28 28 28)
    ("gray11" 28 28 28)
    ("grey10" 26 26 26)
    ("gray10" 26 26 26)
    ("grey9" 23 23 23)
    ("gray9" 23 23 23)
    ("grey8" 20 20 20)
    ("gray8" 20 20 20)
    ("grey7" 18 18 18)
    ("gray7" 18 18 18)
    ("grey6" 15 15 15)
    ("gray6" 15 15 15)
    ("grey5" 13 13 13)
    ("gray5" 13 13 13)
    ("grey4" 10 10 10)
    ("gray4" 10 10 10)
    ("grey3" 8 8 8)
    ("gray3" 8 8 8)
    ("grey2" 5 5 5)
    ("gray2" 5 5 5)
    ("grey1" 3 3 3)
    ("gray1" 3 3 3)
    ("grey0" 0 0 0)
    ("gray0" 0 0 0)
    ("thistle4" 139 123 139)
    ("thistle3" 205 181 205)
    ("thistle2" 238 210 238)
    ("thistle1" 255 225 255)
    ("MediumPurple4" 93 71 139)
    ("MediumPurple3" 137 104 205)
    ("MediumPurple2" 159 121 238)
    ("MediumPurple1" 171 130 255)
    ("purple4" 85 26 139)
    ("purple3" 125 38 205)
    ("purple2" 145 44 238)
    ("purple1" 155 48 255)
    ("DarkOrchid4" 104 34 139)
    ("DarkOrchid3" 154 50 205)
    ("DarkOrchid2" 178 58 238)
    ("DarkOrchid1" 191 62 255)
    ("MediumOrchid4" 122 55 139)
    ("MediumOrchid3" 180 82 205)
    ("MediumOrchid2" 209 95 238)
    ("MediumOrchid1" 224 102 255)
    ("plum4" 139 102 139)
    ("plum3" 205 150 205)
    ("plum2" 238 174 238)
    ("plum1" 255 187 255)
    ("orchid4" 139 71 137)
    ("orchid3" 205 105 201)
    ("orchid2" 238 122 233)
    ("orchid1" 255 131 250)
    ("magenta4" 139 0 139)
    ("magenta3" 205 0 205)
    ("magenta2" 238 0 238)
    ("magenta1" 255 0 255)
    ("VioletRed4" 139 34 82)
    ("VioletRed3" 205 50 120)
    ("VioletRed2" 238 58 140)
    ("VioletRed1" 255 62 150)
    ("maroon4" 139 28 98)
    ("maroon3" 205 41 144)
    ("maroon2" 238 48 167)
    ("maroon1" 255 52 179)
    ("PaleVioletRed4" 139 71 93)
    ("PaleVioletRed3" 205 104 137)
    ("PaleVioletRed2" 238 121 159)
    ("PaleVioletRed1" 255 130 171)
    ("LightPink4" 139 95 101)
    ("LightPink3" 205 140 149)
    ("LightPink2" 238 162 173)
    ("LightPink1" 255 174 185)
    ("pink4" 139 99 108)
    ("pink3" 205 145 158)
    ("pink2" 238 169 184)
    ("pink1" 255 181 197)
    ("HotPink4" 139 58 98)
    ("HotPink3" 205 96 144)
    ("HotPink2" 238 106 167)
    ("HotPink1" 255 110 180)
    ("DeepPink4" 139 10 80)
    ("DeepPink3" 205 16 118)
    ("DeepPink2" 238 18 137)
    ("DeepPink1" 255 20 147)
    ("red4" 139 0 0)
    ("red3" 205 0 0)
    ("red2" 238 0 0)
    ("red1" 255 0 0)
    ("OrangeRed4" 139 37 0)
    ("OrangeRed3" 205 55 0)
    ("OrangeRed2" 238 64 0)
    ("OrangeRed1" 255 69 0)
    ("tomato4" 139 54 38)
    ("tomato3" 205 79 57)
    ("tomato2" 238 92 66)
    ("tomato1" 255 99 71)
    ("coral4" 139 62 47)
    ("coral3" 205 91 69)
    ("coral2" 238 106 80)
    ("coral1" 255 114 86)
    ("DarkOrange4" 139 69 0)
    ("DarkOrange3" 205 102 0)
    ("DarkOrange2" 238 118 0)
    ("DarkOrange1" 255 127 0)
    ("orange4" 139 90 0)
    ("orange3" 205 133 0)
    ("orange2" 238 154 0)
    ("orange1" 255 165 0)
    ("LightSalmon4" 139 87 66)
    ("LightSalmon3" 205 129 98)
    ("LightSalmon2" 238 149 114)
    ("LightSalmon1" 255 160 122)
    ("salmon4" 139 76 57)
    ("salmon3" 205 112 84)
    ("salmon2" 238 130 98)
    ("salmon1" 255 140 105)
    ("brown4" 139 35 35)
    ("brown3" 205 51 51)
    ("brown2" 238 59 59)
    ("brown1" 255 64 64)
    ("firebrick4" 139 26 26)
    ("firebrick3" 205 38 38)
    ("firebrick2" 238 44 44)
    ("firebrick1" 255 48 48)
    ("chocolate4" 139 69 19)
    ("chocolate3" 205 102 29)
    ("chocolate2" 238 118 33)
    ("chocolate1" 255 127 36)
    ("tan4" 139 90 43)
    ("tan3" 205 133 63)
    ("tan2" 238 154 73)
    ("tan1" 255 165 79)
    ("wheat4" 139 126 102)
    ("wheat3" 205 186 150)
    ("wheat2" 238 216 174)
    ("wheat1" 255 231 186)
    ("burlywood4" 139 115 85)
    ("burlywood3" 205 170 125)
    ("burlywood2" 238 197 145)
    ("burlywood1" 255 211 155)
    ("sienna4" 139 71 38)
    ("sienna3" 205 104 57)
    ("sienna2" 238 121 66)
    ("sienna1" 255 130 71)
    ("IndianRed4" 139 58 58)
    ("IndianRed3" 205 85 85)
    ("IndianRed2" 238 99 99)
    ("IndianRed1" 255 106 106)
    ("RosyBrown4" 139 105 105)
    ("RosyBrown3" 205 155 155)
    ("RosyBrown2" 238 180 180)
    ("RosyBrown1" 255 193 193)
    ("DarkGoldenrod4" 139 101 8)
    ("DarkGoldenrod3" 205 149 12)
    ("DarkGoldenrod2" 238 173 14)
    ("DarkGoldenrod1" 255 185 15)
    ("goldenrod4" 139 105 20)
    ("goldenrod3" 205 155 29)
    ("goldenrod2" 238 180 34)
    ("goldenrod1" 255 193 37)
    ("gold4" 139 117 0)
    ("gold3" 205 173 0)
    ("gold2" 238 201 0)
    ("gold1" 255 215 0)
    ("yellow4" 139 139 0)
    ("yellow3" 205 205 0)
    ("yellow2" 238 238 0)
    ("yellow1" 255 255 0)
    ("LightYellow4" 139 139 122)
    ("LightYellow3" 205 205 180)
    ("LightYellow2" 238 238 209)
    ("LightYellow1" 255 255 224)
    ("LightGoldenrod4" 139 129 76)
    ("LightGoldenrod3" 205 190 112)
    ("LightGoldenrod2" 238 220 130)
    ("LightGoldenrod1" 255 236 139)
    ("khaki4" 139 134 78)
    ("khaki3" 205 198 115)
    ("khaki2" 238 230 133)
    ("khaki1" 255 246 143)
    ("DarkOliveGreen4" 110 139 61)
    ("DarkOliveGreen3" 162 205 90)
    ("DarkOliveGreen2" 188 238 104)
    ("DarkOliveGreen1" 202 255 112)
    ("OliveDrab4" 105 139 34)
    ("OliveDrab3" 154 205 50)
    ("OliveDrab2" 179 238 58)
    ("OliveDrab1" 192 255 62)
    ("chartreuse4" 69 139 0)
    ("chartreuse3" 102 205 0)
    ("chartreuse2" 118 238 0)
    ("chartreuse1" 127 255 0)
    ("green4" 0 139 0)
    ("green3" 0 205 0)
    ("green2" 0 238 0)
    ("green1" 0 255 0)
    ("SpringGreen4" 0 139 69)
    ("SpringGreen3" 0 205 102)
    ("SpringGreen2" 0 238 118)
    ("SpringGreen1" 0 255 127)
    ("PaleGreen4" 84 139 84)
    ("PaleGreen3" 124 205 124)
    ("PaleGreen2" 144 238 144)
    ("PaleGreen1" 154 255 154)
    ("SeaGreen4" 46 139 87)
    ("SeaGreen3" 67 205 128)
    ("SeaGreen2" 78 238 148)
    ("SeaGreen1" 84 255 159)
    ("DarkSeaGreen4" 105 139 105)
    ("DarkSeaGreen3" 155 205 155)
    ("DarkSeaGreen2" 180 238 180)
    ("DarkSeaGreen1" 193 255 193)
    ("aquamarine4" 69 139 116)
    ("aquamarine3" 102 205 170)
    ("aquamarine2" 118 238 198)
    ("aquamarine1" 127 255 212)
    ("DarkSlateGray4" 82 139 139)
    ("DarkSlateGray3" 121 205 205)
    ("DarkSlateGray2" 141 238 238)
    ("DarkSlateGray1" 151 255 255)
    ("cyan4" 0 139 139)
    ("cyan3" 0 205 205)
    ("cyan2" 0 238 238)
    ("cyan1" 0 255 255)
    ("turquoise4" 0 134 139)
    ("turquoise3" 0 197 205)
    ("turquoise2" 0 229 238)
    ("turquoise1" 0 245 255)
    ("CadetBlue4" 83 134 139)
    ("CadetBlue3" 122 197 205)
    ("CadetBlue2" 142 229 238)
    ("CadetBlue1" 152 245 255)
    ("PaleTurquoise4" 102 139 139)
    ("PaleTurquoise3" 150 205 205)
    ("PaleTurquoise2" 174 238 238)
    ("PaleTurquoise1" 187 255 255)
    ("LightCyan4" 122 139 139)
    ("LightCyan3" 180 205 205)
    ("LightCyan2" 209 238 238)
    ("LightCyan1" 224 255 255)
    ("LightBlue4" 104 131 139)
    ("LightBlue3" 154 192 205)
    ("LightBlue2" 178 223 238)
    ("LightBlue1" 191 239 255)
    ("LightSteelBlue4" 110 123 139)
    ("LightSteelBlue3" 162 181 205)
    ("LightSteelBlue2" 188 210 238)
    ("LightSteelBlue1" 202 225 255)
    ("SlateGray4" 108 123 139)
    ("SlateGray3" 159 182 205)
    ("SlateGray2" 185 211 238)
    ("SlateGray1" 198 226 255)
    ("LightSkyBlue4" 96 123 139)
    ("LightSkyBlue3" 141 182 205)
    ("LightSkyBlue2" 164 211 238)
    ("LightSkyBlue1" 176 226 255)
    ("SkyBlue4" 74 112 139)
    ("SkyBlue3" 108 166 205)
    ("SkyBlue2" 126 192 238)
    ("SkyBlue1" 135 206 255)
    ("DeepSkyBlue4" 0 104 139)
    ("DeepSkyBlue3" 0 154 205)
    ("DeepSkyBlue2" 0 178 238)
    ("DeepSkyBlue1" 0 191 255)
    ("SteelBlue4" 54 100 139)
    ("SteelBlue3" 79 148 205)
    ("SteelBlue2" 92 172 238)
    ("SteelBlue1" 99 184 255)
    ("DodgerBlue4" 16 78 139)
    ("DodgerBlue3" 24 116 205)
    ("DodgerBlue2" 28 134 238)
    ("DodgerBlue1" 30 144 255)
    ("blue4" 0 0 139)
    ("blue3" 0 0 205)
    ("blue2" 0 0 238)
    ("blue1" 0 0 255)
    ("RoyalBlue4" 39 64 139)
    ("RoyalBlue3" 58 95 205)
    ("RoyalBlue2" 67 110 238)
    ("RoyalBlue1" 72 118 255)
    ("SlateBlue4" 71 60 139)
    ("SlateBlue3" 105 89 205)
    ("SlateBlue2" 122 103 238)
    ("SlateBlue1" 131 111 255)
    ("azure4" 131 139 139)
    ("azure3" 193 205 205)
    ("azure2" 224 238 238)
    ("azure1" 240 255 255)
    ("MistyRose4" 139 125 123)
    ("MistyRose3" 205 183 181)
    ("MistyRose2" 238 213 210)
    ("MistyRose1" 255 228 225)
    ("LavenderBlush4" 139 131 134)
    ("LavenderBlush3" 205 193 197)
    ("LavenderBlush2" 238 224 229)
    ("LavenderBlush1" 255 240 245)
    ("honeydew4" 131 139 131)
    ("honeydew3" 193 205 193)
    ("honeydew2" 224 238 224)
    ("honeydew1" 240 255 240)
    ("ivory4" 139 139 131)
    ("ivory3" 205 205 193)
    ("ivory2" 238 238 224)
    ("ivory1" 255 255 240)
    ("cornsilk4" 139 136 120)
    ("cornsilk3" 205 200 177)
    ("cornsilk2" 238 232 205)
    ("cornsilk1" 255 248 220)
    ("LemonChiffon4" 139 137 112)
    ("LemonChiffon3" 205 201 165)
    ("LemonChiffon2" 238 233 191)
    ("LemonChiffon1" 255 250 205)
    ("NavajoWhite4" 139 121 94)
    ("NavajoWhite3" 205 179 139)
    ("NavajoWhite2" 238 207 161)
    ("NavajoWhite1" 255 222 173)
    ("PeachPuff4" 139 119 101)
    ("PeachPuff3" 205 175 149)
    ("PeachPuff2" 238 203 173)
    ("PeachPuff1" 255 218 185)
    ("bisque4" 139 125 107)
    ("bisque3" 205 183 158)
    ("bisque2" 238 213 183)
    ("bisque1" 255 228 196)
    ("AntiqueWhite4" 139 131 120)
    ("AntiqueWhite3" 205 192 176)
    ("AntiqueWhite2" 238 223 204)
    ("AntiqueWhite1" 255 239 219)
    ("seashell4" 139 134 130)
    ("seashell3" 205 197 191)
    ("seashell2" 238 229 222)
    ("seashell1" 255 245 238)
    ("snow4" 139 137 137)
    ("snow3" 205 201 201)
    ("snow2" 238 233 233)
    ("snow1" 255 250 250)
    ("thistle" 216 191 216)
    ("MediumPurple" 147 112 219)
    ("medium purple" 147 112 219)
    ("purple" 160 32 240)
    ("BlueViolet" 138 43 226)
    ("blue violet" 138 43 226)
    ("DarkViolet" 148 0 211)
    ("dark violet" 148 0 211)
    ("DarkOrchid" 153 50 204)
    ("dark orchid" 153 50 204)
    ("MediumOrchid" 186 85 211)
    ("medium orchid" 186 85 211)
    ("orchid" 218 112 214)
    ("plum" 221 160 221)
    ("violet" 238 130 238)
    ("magenta" 255 0 255)
    ("VioletRed" 208 32 144)
    ("violet red" 208 32 144)
    ("MediumVioletRed" 199 21 133)
    ("medium violet red" 199 21 133)
    ("maroon" 176 48 96)
    ("PaleVioletRed" 219 112 147)
    ("pale violet red" 219 112 147)
    ("LightPink" 255 182 193)
    ("light pink" 255 182 193)
    ("pink" 255 192 203)
    ("DeepPink" 255 20 147)
    ("deep pink" 255 20 147)
    ("HotPink" 255 105 180)
    ("hot pink" 255 105 180)
    ("red" 255 0 0)
    ("OrangeRed" 255 69 0)
    ("orange red" 255 69 0)
    ("tomato" 255 99 71)
    ("LightCoral" 240 128 128)
    ("light coral" 240 128 128)
    ("coral" 255 127 80)
    ("DarkOrange" 255 140 0)
    ("dark orange" 255 140 0)
    ("orange" 255 165 0)
    ("LightSalmon" 255 160 122)
    ("light salmon" 255 160 122)
    ("salmon" 250 128 114)
    ("DarkSalmon" 233 150 122)
    ("dark salmon" 233 150 122)
    ("brown" 165 42 42)
    ("firebrick" 178 34 34)
    ("chocolate" 210 105 30)
    ("tan" 210 180 140)
    ("SandyBrown" 244 164 96)
    ("sandy brown" 244 164 96)
    ("wheat" 245 222 179)
    ("beige" 245 245 220)
    ("burlywood" 222 184 135)
    ("peru" 205 133 63)
    ("sienna" 160 82 45)
    ("SaddleBrown" 139 69 19)
    ("saddle brown" 139 69 19)
    ("IndianRed" 205 92 92)
    ("indian red" 205 92 92)
    ("RosyBrown" 188 143 143)
    ("rosy brown" 188 143 143)
    ("DarkGoldenrod" 184 134 11)
    ("dark goldenrod" 184 134 11)
    ("goldenrod" 218 165 32)
    ("LightGoldenrod" 238 221 130)
    ("light goldenrod" 238 221 130)
    ("gold" 255 215 0)
    ("yellow" 255 255 0)
    ("LightYellow" 255 255 224)
    ("light yellow" 255 255 224)
    ("LightGoldenrodYellow" 250 250 210)
    ("light goldenrod yellow" 250 250 210)
    ("PaleGoldenrod" 238 232 170)
    ("pale goldenrod" 238 232 170)
    ("khaki" 240 230 140)
    ("DarkKhaki" 189 183 107)
    ("dark khaki" 189 183 107)
    ("OliveDrab" 107 142 35)
    ("olive drab" 107 142 35)
    ("ForestGreen" 34 139 34)
    ("forest green" 34 139 34)
    ("YellowGreen" 154 205 50)
    ("yellow green" 154 205 50)
    ("LimeGreen" 50 205 50)
    ("lime green" 50 205 50)
    ("GreenYellow" 173 255 47)
    ("green yellow" 173 255 47)
    ("MediumSpringGreen" 0 250 154)
    ("medium spring green" 0 250 154)
    ("chartreuse" 127 255 0)
    ("green" 0 255 0)
    ("LawnGreen" 124 252 0)
    ("lawn green" 124 252 0)
    ("SpringGreen" 0 255 127)
    ("spring green" 0 255 127)
    ("PaleGreen" 152 251 152)
    ("pale green" 152 251 152)
    ("LightSeaGreen" 32 178 170)
    ("light sea green" 32 178 170)
    ("MediumSeaGreen" 60 179 113)
    ("medium sea green" 60 179 113)
    ("SeaGreen" 46 139 87)
    ("sea green" 46 139 87)
    ("DarkSeaGreen" 143 188 143)
    ("dark sea green" 143 188 143)
    ("DarkOliveGreen" 85 107 47)
    ("dark olive green" 85 107 47)
    ("DarkGreen" 0 100 0)
    ("dark green" 0 100 0)
    ("aquamarine" 127 255 212)
    ("MediumAquamarine" 102 205 170)
    ("medium aquamarine" 102 205 170)
    ("CadetBlue" 95 158 160)
    ("cadet blue" 95 158 160)
    ("LightCyan" 224 255 255)
    ("light cyan" 224 255 255)
    ("cyan" 0 255 255)
    ("turquoise" 64 224 208)
    ("MediumTurquoise" 72 209 204)
    ("medium turquoise" 72 209 204)
    ("DarkTurquoise" 0 206 209)
    ("dark turquoise" 0 206 209)
    ("PaleTurquoise" 175 238 238)
    ("pale turquoise" 175 238 238)
    ("PowderBlue" 176 224 230)
    ("powder blue" 176 224 230)
    ("LightBlue" 173 216 230)
    ("light blue" 173 216 230)
    ("LightSteelBlue" 176 196 222)
    ("light steel blue" 176 196 222)
    ("SteelBlue" 70 130 180)
    ("steel blue" 70 130 180)
    ("LightSkyBlue" 135 206 250)
    ("light sky blue" 135 206 250)
    ("SkyBlue" 135 206 235)
    ("sky blue" 135 206 235)
    ("DeepSkyBlue" 0 191 255)
    ("deep sky blue" 0 191 255)
    ("DodgerBlue" 30 144 255)
    ("dodger blue" 30 144 255)
    ("blue" 0 0 255)
    ("RoyalBlue" 65 105 225)
    ("royal blue" 65 105 225)
    ("MediumBlue" 0 0 205)
    ("medium blue" 0 0 205)
    ("LightSlateBlue" 132 112 255)
    ("light slate blue" 132 112 255)
    ("MediumSlateBlue" 123 104 238)
    ("medium slate blue" 123 104 238)
    ("SlateBlue" 106 90 205)
    ("slate blue" 106 90 205)
    ("DarkSlateBlue" 72 61 139)
    ("dark slate blue" 72 61 139)
    ("CornflowerBlue" 100 149 237)
    ("cornflower blue" 100 149 237)
    ("NavyBlue" 0 0 128)
    ("navy blue" 0 0 128)
    ("navy" 0 0 128)
    ("MidnightBlue" 25 25 112)
    ("midnight blue" 25 25 112)
    ("LightGray" 211 211 211)
    ("light gray" 211 211 211)
    ("LightGrey" 211 211 211)
    ("light grey" 211 211 211)
    ("grey" 190 190 190)
    ("gray" 190 190 190)
    ("LightSlateGrey" 119 136 153)
    ("light slate grey" 119 136 153)
    ("LightSlateGray" 119 136 153)
    ("light slate gray" 119 136 153)
    ("SlateGrey" 112 128 144)
    ("slate grey" 112 128 144)
    ("SlateGray" 112 128 144)
    ("slate gray" 112 128 144)
    ("DimGrey" 105 105 105)
    ("dim grey" 105 105 105)
    ("DimGray" 105 105 105)
    ("dim gray" 105 105 105)
    ("DarkSlateGrey" 47 79 79)
    ("dark slate grey" 47 79 79)
    ("DarkSlateGray" 47 79 79)
    ("dark slate gray" 47 79 79)
    ("black" 0 0 0)
    ("white" 255 255 255)
    ("MistyRose" 255 228 225)
    ("misty rose" 255 228 225)
    ("LavenderBlush" 255 240 245)
    ("lavender blush" 255 240 245)
    ("lavender" 230 230 250)
    ("AliceBlue" 240 248 255)
    ("alice blue" 240 248 255)
    ("azure" 240 255 255)
    ("MintCream" 245 255 250)
    ("mint cream" 245 255 250)
    ("honeydew" 240 255 240)
    ("seashell" 255 245 238)
    ("LemonChiffon" 255 250 205)
    ("lemon chiffon" 255 250 205)
    ("ivory" 255 255 240)
    ("cornsilk" 255 248 220)
    ("moccasin" 255 228 181)
    ("NavajoWhite" 255 222 173)
    ("navajo white" 255 222 173)
    ("PeachPuff" 255 218 185)
    ("peach puff" 255 218 185)
    ("bisque" 255 228 196)
    ("BlanchedAlmond" 255 235 205)
    ("blanched almond" 255 235 205)
    ("PapayaWhip" 255 239 213)
    ("papaya whip" 255 239 213)
    ("AntiqueWhite" 250 235 215)
    ("antique white" 250 235 215)
    ("linen" 250 240 230)
    ("OldLace" 253 245 230)
    ("old lace" 253 245 230)
    ("FloralWhite" 255 250 240)
    ("floral white" 255 250 240)
    ("gainsboro" 220 220 220)
    ("WhiteSmoke" 245 245 245)
    ("white smoke" 245 245 245)
    ("GhostWhite" 248 248 255)
    ("ghost white" 248 248 255)
    ("snow" 255 250 250)))

#-lispworks
(defvar *x11-color-string-map*
  (let ((h (make-hash-table :test #'equal)))
    (dolist (c *x11-colors*)
      (setf (gethash (string-downcase (car c)) h)
	    (mapcar (lambda (v) (/ v 255.0))
		    (cdr c))))
    h)
  "Hash table mapping lowercase color strings to (r g b) lists")

#-lispworks
(defvar *x11-color-keyword-map*
  (let ((h (make-hash-table :test #'eq)))
    (dolist (c *x11-colors*)
      (setf (gethash (intern (string-upcase (car c)) "KEYWORD")
		     h)
	    (mapcar (lambda (v) (/ v 255.0))
		    (cdr c))))
    h)
  "Hash table mapping :COLOR keywords to (r g b) lists")

(defun find-color-from-symbol (color-symbol)
  #-lispworks
  (values-list (gethash color-symbol *x11-color-keyword-map*))
  #+lispworks
  (lw:when-let (color (color:get-color-spec color-symbol))
	       (get-rgb color)))

(defun find-color-from-string (color-string)
  #-lispworks
  (values-list (gethash (string-downcase color-string) *x11-color-string-map*))
  #+lispworks
  (lw:when-let (color (color:get-color-spec (find-symbol (string-upcase color-string) :keyword)))
	       (get-rgb color)))

;; only needed to run this once to generate the color table above
#-(and)
(defun generate-color-table (&optional (rgb-db #p"/usr/lib/X11/rgb.txt"))
  (let ((colors nil))
  (with-open-file (i rgb-db :direction :input)
    (do ((line (read-line i nil :eof)
	       (read-line i nil :eof)))
	((eq line :eof))
      (multiple-value-bind (match regs)
	  (cl-ppcre:scan-to-strings
	   "^\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(.*?)\\s*$"
	   line)
	(if match
	    (push (list (aref regs 3)
			(parse-integer (aref regs 0))
			(parse-integer (aref regs 1))
			(parse-integer (aref regs 2)))
		  colors)))))
  (format t "(~{~S~%~})" colors)
  nil))
