/*--------------------------------------------------------------------*/
/*--- Callgrind                                                    ---*/
/*---                                                     static.c ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Callgrind, a Valgrind tool for call tracing.

   Copyright (C) 2005, Josef Weidendorfer (Josef.Weidendorfer@gmx.de)

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/

/* This is more or less copied from my stagrind tool for better
 * integration with callgrind and easier usage with kcachegrind.
 */

#include "global.h"


/*
 * HACK: Needed function from valgrind core not found in tool.h
 *
 * From tool.h:
 *  typedef struct _UCodeBlock UCodeBlock;
 */



/*------------------------------------------------------------*/
/*--- Dumps static info for code coverage                  ---*/
/*------------------------------------------------------------*/


#define FILENAME_LEN                    256
#define FN_NAME_LEN                    4096 /* for C++ code :-) */

#if 0
static Char buf[512];
static Char outname[512];
static Char filename[FILENAME_LEN], last_filename[FILENAME_LEN];
static Char fn_filename[FILENAME_LEN];
static Char fn_name[FN_NAME_LEN], last_fn_name[FN_NAME_LEN];
#endif

void CLG_(dump_obj)(obj_node* obj)
{
#if 0
  Int fd, line, size, pos, i;
  UInt instrs;
  Bool is_last;
  UInt rsize, wsize;
  UInt rsizes, wsizes;
  Addr addr, end, bbaddr;
  UCodeBlock* cb;
  UInstr*     u;
 
  VG_(sprintf)(outname, "%s.%s",
	       SK_(get_dump_file_base)(),
	       obj->name + obj->last_slash_pos);

  /* Do nothing if file already exists.
   * FIXME: Check absolute path name and modification times
   */
  
  fd = VG_(open)(outname,
		 VKI_O_CREAT|VKI_O_EXCL|VKI_O_WRONLY,
		 VKI_S_IRUSR|VKI_S_IWUSR);
  
  if (fd<0) {
    if (VG_(clo_verbosity) > 1) {
      VG_(message)(Vg_DebugMsg, "Static info for '%s' "
		   "not dumped because of existance", obj->name);
      VG_(message)(Vg_DebugMsg, "of %s.", outname);
    }
    return;
  }
  if (VG_(clo_verbosity) > 1)
    VG_(message)(Vg_DebugMsg, "Dumping static info to '%s'...", outname);
  
  /* write header */
  VG_(sprintf)(buf, "version: 1\n");
  VG_(write)(fd, (void*)buf, VG_(strlen)(buf));
  
  VG_(sprintf)(buf, "creator: callgrind-" VERSION "\n");
  VG_(write)(fd, (void*)buf, VG_(strlen)(buf));
  
  /* "positions:" line */
  VG_(sprintf)(buf, "\npositions: instr line\n");
  VG_(write)(fd, (void*)buf, VG_(strlen)(buf));
  
  /* "events:" line: distinct instructions with debug info,
   *                 memory read size, memory write size
   */ 
  VG_(sprintf)(buf, "events: DbgIr MrSz MwSz\n\n");
  VG_(write)(fd, (void*)buf, VG_(strlen)(buf));
  
  VG_(sprintf)(buf, "ob=%s\n", obj->name);
  VG_(write)(fd, (void*)buf, VG_(strlen)(buf));
  
  
  addr = obj->start;
  end = obj->start + obj->size;

  last_fn_name[0] = 0;
  last_filename[0] = 0;
 
  instrs = 0;
  rsizes = wsizes = 0;  
 
  while(addr < end) {
     
    /* search for address with line debug info */
    while(addr < end) {
      if (VG_(get_filename_linenum)(addr, filename, FILENAME_LEN, &line))
        break;
      addr++;
    }
    if (addr == end) break;
    
    /* this always should be inside of a function */
    if (!VG_(get_fnname)(addr, fn_name, FN_NAME_LEN)) { addr++; continue; }
     
    /* decode a basic block */
    bbaddr = addr;
    ucb.orig_eip = addr;
    cb = VG_(setup_UCodeBlock)(&ucb);
    size = VG_(disBB)(cb, addr);    
    if (size <=0) {
      /* skip on error: not decodable? */
      VG_(free_UCodeBlock)(cb);
      continue;
    }
     
    /* function name change? */
    if (VG_(strcmp)(fn_name, last_fn_name) != 0) {
      VG_(strcpy)(last_fn_name, fn_name);
      VG_(write)(fd, "\n", 1);
 
      /* first print filename, if there"s a change */
      if (VG_(strcmp)(filename, last_filename) != 0) {
        VG_(strcpy)(last_filename, filename);
        VG_(strcpy)(fn_filename, filename);       
        VG_(sprintf)(buf, "fl=%s\n", filename);
        VG_(write)(fd, (void*)buf, VG_(strlen)(buf));
      }      
      
      VG_(sprintf)(buf, "fn=%s\n", fn_name);
      VG_(write)(fd, (void*)buf, VG_(strlen)(buf));
    }
 
    rsize = wsize = 0;
 
    /* iterate through all instructions of current basic block */
    for (i = 0; i < VG_(get_num_instrs)(cb); i++) {
      u = VG_(get_instr)(cb, i);
 
      switch(u->opcode) {
      case LOAD:
      case MMX2_MemRd:
      case FPU_R:
      case SSE2a_MemRd:
      case SSE2a1_MemRd:
      case SSE3a_MemRd:
      case SSE3a1_MemRd:
      case SSE3ag_MemRd_RegWr:
        rsize += u->size;
        break;
 
      case STORE:
      case MMX2_MemWr: 
      case FPU_W:
      case SSE2a_MemWr:
      case SSE3a_MemWr:
        wsize += u->size;
        break;
 
      default:
        break;
      }
 
      /* we write instruction info on x86 boundary (INCEIP) or
       * on last UOp in basic block.
       */
      is_last = (i+1 == VG_(get_num_instrs)(cb));
      if (!is_last && (u->opcode != INCEIP)) continue;
      
      /* break out if this instruction doesn"t have a debug line.
       * Should this be changed to an asserttion ?
       */
      if (!VG_(get_filename_linenum)(addr, filename, FILENAME_LEN, &line))
        break;
 
      /* source file changed inside of a function? */
      if (VG_(strcmp)(filename, last_filename) != 0) {
        VG_(strcpy)(last_filename, filename);
        if (VG_(strcmp)(filename, fn_filename) != 0)
          VG_(sprintf)(buf, "fi=%s\n", filename);
        else
          VG_(sprintf)(buf, "fe=%s\n", filename);
        VG_(write)(fd, (void*)buf, VG_(strlen)(buf));
      }
        
      /* instruction info: <relative address> <line> events ... */
      pos = VG_(sprintf)(buf, "%p %u 1", addr - obj->offset, line);
      if (wsize>0)
        pos += VG_(sprintf)(buf+pos, " %d %d\n", rsize, wsize);
      else if (rsize>0)
        pos += VG_(sprintf)(buf+pos, " %d\n", rsize);
      else
        pos += VG_(sprintf)(buf+pos, "\n");
      VG_(write)(fd, buf, pos);

      instrs++;
      rsizes  += rsize;
      wsizes  += wsize;
 
      rsize = wsize = 0;
 
      /* For INCEIP, we have instruction size.
       * No need to update address last UOp!
       */
      if (!is_last) addr += u->val1;
    }
    VG_(free_UCodeBlock)(cb);
 
    addr = bbaddr + size;
  }
 
  pos = VG_(sprintf)(buf, "\nsummary: %d %d %d\n",
		     instrs, rsizes, wsizes);
  VG_(write)(fd, buf, pos);
 
  VG_(close)(fd);
#endif
}
