/*
 * aufs sample -- ULOOP driver and ulohttp
 *
 * Copyright (C) 2007 Junjiro Okajima
 *
 * This program, aufs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* $Id: uloop.h,v 1.1 2007/08/06 00:38:07 sfjro Exp $ */

#ifndef __ULOOP_H__
#define __ULOOP_H__

#include <linux/ioctl.h>
#include <linux/loop.h>
#include <linux/unistd.h>
#ifndef __KERNEL__
#include <sys/types.h>
#endif

#define ULOOP_NAME	"uloop"
#define ULOOP_VERSION	"20070806"

/* variations */
#define ULOOP_HTTP	(MAX_LO_CRYPT - 1)

/* ioctl */
#ifndef LOOP_CHANGE_FD
#define LOOP_CHANGE_FD	0x4C06
#endif
enum {UloCtlErr, UloCtlErr_Last};
enum {
	/* LOOP_CHANGE_FD is the last number in loop ioctl */
	UloCtl_Begin = (LOOP_CHANGE_FD & 0x0ff),
	UloCtl_SETBMP,
	UloCtl_READY,
	UloCtl_RCVREQ,
	UloCtl_SNDRES
};

struct uloop_ctl_setbmp {
	int	fd;
	int	pagesize;
};

struct uloop_ctl_ready {
	int	signum;
	pid_t	pid;
};

struct uloop_ctl_rcvreq {
	unsigned long long	start;
	int			size;
};

struct uloop_ctl_sndres {
	unsigned long long	start;
	int			size;
};

union uloop_ctl {
	struct uloop_ctl_setbmp	setbmp;
	struct uloop_ctl_ready	ready;
	struct uloop_ctl_rcvreq	rcvreq;
	struct uloop_ctl_sndres	sndres;
};

#define ULOCTL_Type	'L'
#define ULOCTL_SETBMP	_IOW(ULOCTL_Type, UloCtl_SETBMP, union uloop_ctl)
#define ULOCTL_READY	_IOR(ULOCTL_Type, UloCtl_READY, union uloop_ctl)
#define ULOCTL_RCVREQ	_IOR(ULOCTL_Type, UloCtl_RCVREQ, union uloop_ctl)
#define ULOCTL_SNDRES	_IOW(ULOCTL_Type, UloCtl_SNDRES, union uloop_ctl)

/* library API */
#ifndef __KERNEL__
#endif

#endif /* __ULOOP_H__ */
