// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_scanner_h__
#define __c_scanner_h__

#include "Puma/CRecognizer.h"
#include "Puma/Location.h"
#include "Puma/LanguageID.h"
#include "Puma/Tokenizer.h"
#include "Puma/Unit.h"
#include "Puma/ErrorSink.h"
#include "Puma/Config.h"
#include "Puma/Source.h"

namespace Puma {


class Token;

class CScanner : public CRecognizer, public Tokenizer {
  Location loc;
  ErrorSink &err;

  Token *make_token (CRecognizer::Lang lang, int expr, int len);
  LanguageID map_lang (CRecognizer::Lang lang);
  Token *scan ();
  void scan_all (Unit &unit);

public:
  CScanner (ErrorSink &error_stream) : err (error_stream) {}
  virtual ~CScanner () {}
  void configure (const Config &);
  void fill_unit (Source &in, Unit &unit);
  void fill_unit (const char *in, Unit &unit);
};


} // namespace Puma

#endif /* __c_scanner_h__ */
