// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CSpecifiers__
#define __CSpecifiers__

// C++ declaration specifiers

namespace Puma {


class CSpecifiers {
public:
  enum Spec {
    SPEC_NONE     = 0x0,
    SPEC_VIRTUAL  = 0x1,
    SPEC_STATIC   = 0x2,
    SPEC_EXTERN   = 0x4,
    SPEC_MUTABLE  = 0x8,
    SPEC_REGISTER = 0x10,
    SPEC_EXPLICIT = 0x20,
    SPEC_AUTO     = 0x40,
    SPEC_INLINE   = 0x80
  };

private:
  unsigned char _specs;
  
public:
  CSpecifiers ();
  CSpecifiers (const CSpecifiers &);
  CSpecifiers &operator =(const CSpecifiers &);

  // add/remove specifier
  CSpecifiers &operator +=(Spec);
  CSpecifiers &operator -=(Spec);
  
  // test for specifier
  bool operator ==(Spec) const;
  bool operator !=(Spec) const;
};

inline CSpecifiers::CSpecifiers () : _specs (SPEC_NONE) 
 {}
inline CSpecifiers::CSpecifiers (const CSpecifiers &s)
 { _specs = s._specs; }
inline CSpecifiers &CSpecifiers::operator =(const CSpecifiers &s)
 { _specs = s._specs; return *(CSpecifiers*)this; }

inline CSpecifiers &CSpecifiers::operator +=(CSpecifiers::Spec s)
 { _specs = _specs | (unsigned char)s; return *(CSpecifiers*)this; }
inline CSpecifiers &CSpecifiers::operator -=(CSpecifiers::Spec s)
 { _specs = _specs ^ (_specs & (unsigned char)s); return *(CSpecifiers*)this; }

inline bool CSpecifiers::operator ==(CSpecifiers::Spec s) const
 { return _specs & (unsigned char)s; }
inline bool CSpecifiers::operator !=(CSpecifiers::Spec s) const
 { return ! (_specs & (unsigned char)s); }


} // namespace Puma

#endif /* __CSpecifiers__ */
