// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_expr__
#define __pre_expr__

// Node class for the preprocessor expression parser. 

#include "Puma/MappedOrangeRecognizer.h"
#include "Puma/Location.h"

namespace Puma {


class ErrorStream;

class PreExpr {
  bool _result;        

public:
  double val;
        
  // Public constructor.
  PreExpr (ErrorStream *, Location);

  // Do not use this contructors outside of the 
  // C preprocessor expression parser.
  PreExpr () {};        
  ~PreExpr () {};        
  PreExpr (unsigned long int value) : val ((double) value) {};        
  PreExpr (long int value) : val ((double) value) {};        
  PreExpr (double value) : val (value) {};        
        
  // Evaluate the given expression string.
  void evaluatePreExpr (char *expression_string);
        
  // Return value of evaluated expression.
  bool value () const { return _result; }
        
  // String conversion method.
  static long int convertChar (char *value);

private:
  static MappedOrangeRecognizer<ScanBuffer> token_recognizer;
};


} // namespace Puma

#endif /* __pre_expr__ */
