// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __location_h__
#define __location_h__

#include "Puma/SmartPtr.h"
#include "Puma/Printable.h"
#include "Puma/LocationInfo.h"

namespace Puma {


class Location : public SmartPtr, public Printable {
  LocationInfo *info () const { return (LocationInfo*)data (); }

public:
  Location () {}
  Location (Filename f, int l) { setup (f, l); }
  Location (LocationInfo *lptr) : SmartPtr (lptr) {}
  LocationInfo *operator ~ () { if (info ()) info ()->ref (); return info (); }
  void setup (Filename f, int l);
  const Filename &filename () const   { return info ()->filename (); }
  int line () const;
  bool operator == (const Location &l) const;
  bool operator != (const Location &l) const { return ! (*this == l); }
  bool operator < (const Location &l) const;

  virtual void print (ostream &os) const {
    if (info ())
#ifdef VISUAL_STUDIO
      os << filename () << "(" << line () << ")";
#else
      os << filename () << ":" << line ();
#endif
  }
};


} // namespace Puma

#endif /* __location_h__ */
