#ifndef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CClassDatabase_h__

#ifndef __ac_h_
#define __ac_h_
namespace AC {
  typedef const char* Type;
  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };
  struct Action {
    void **_args; void *_result; void *_target; void *_that; void *_fptr;
    void (*_wrapper)(Action &);
    inline void trigger () { _wrapper (*this); }
  };
  struct AnyResultBuffer {};
  template <typename T> struct ResultBuffer : public AnyResultBuffer {
    char _data[sizeof (T)];
    ~ResultBuffer () { ((T*)_data)->T::~T(); }
    operator T& () const { return *(T*)_data; }
  };
  template <class Aspect, int Index>
  struct CFlow {
    static int &instance () {
      static int counter = 0;
      return counter;
    }
    CFlow () { instance ()++; }
    ~CFlow () { instance ()--; }
    static bool active () { return instance () > 0; }
  };
}
inline void * operator new (__SIZE_TYPE__, AC::AnyResultBuffer *p) { return p; }
inline void operator delete (void *, AC::AnyResultBuffer *) { } // for VC++
#endif // __ac_h_
#endif // __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__

#ifndef __ac_fwd_ExtAC__
#define __ac_fwd_ExtAC__
class ExtAC;
namespace AC {
  template <class JoinPoint>
  inline void invoke_ExtAC_ExtAC_a0_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtAC_ExtAC_a1_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtAC_ExtAC_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtAC_ExtAC_a3_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtAC_ExtAC_a4_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtAC_ExtAC_a5_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtAC_ExtAC_a6_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtAC_ExtAC_a7_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtAC_ExtAC_a8_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtAC_ExtAC_a9_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtAC_ExtAC_a10_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#endif
#include "ExtAC.ah"
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CClassDatabase_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CClassDatabase_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CClassDatabase_h__
#define __CClassDatabase_h__

#include "Puma/CScopeInfo.h"
#include "Puma/CProject.h"
#include <iostream>
using namespace std;

namespace Puma {


class CObjectInfo;
class CClassInfo;
class CUnionInfo;
class CEnumInfo;
class CTypedefInfo;
class CTemplateParamInfo;
class CTypeInfo;
class CFileInfo;
class Token;

/** \file 
 *  Database of all semantic objects (infos) of a project. 
 *  \see Puma::CClassDatabase */

/** \class CClassDatabase CClassDatabase.h Puma/infos/CClassDatabase.h
 *  A CClassDatabase object is a database of all semantic objects
 *  (infos) of a project. */
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CClassDatabase  :public ACClassDatabase {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  
  Array<CObjectInfo*> _Classes;   // index of classes
  Array<CObjectInfo*> _Unions;    // index of unions
  Array<CObjectInfo*> _Enums;     // index of enums
  Array<CObjectInfo*> _Typedefs;  // index of typedefs
  Array<CObjectInfo*> _Functions; // index of functions
  Array<CObjectInfo*> _Files;     // index of files

  CProject *_Project; // associated project
  
public:
  /** Construct a class database object.
   *  \param prj The corresponding project.
   *  \param size Not used. */
  CClassDatabase (CProject &prj, int size = 997);
  /** Destruct the class database. Also destroys all infos
   *  in the database. */
  virtual ~CClassDatabase ();

  // access to the database entries /////////////////////////////
  
  /** Get the number of semantic object infos. */
  unsigned ObjectInfos () const;
  /** Get the number of class infos. */
  unsigned ClassInfos () const;
  /** Get the number of union infos. */
  unsigned UnionInfos () const;
  /** Get the number of enumeration infos. */
  unsigned EnumInfos () const;
  /** Get the number of typedef infos. */
  unsigned TypedefInfos () const;
  /** Get the number of function infos. */
  unsigned FunctionInfos () const;
  /** Get the number of file infos. */
  unsigned FileInfos () const;
  /** Get the n-th semantic object info.
   *  \param n The number of the info.
   *  \return The info or \c NULL if \e n is invalid. */
  CObjectInfo *ObjectInfo (unsigned n) const;
  /** Get the n-th class info.
   *  \param n The number of the info.
   *  \return The info or \c NULL if \e n is invalid. */
  CClassInfo *ClassInfo (unsigned n) const;
  /** Get the n-th union info.
   *  \param n The number of the info.
   *  \return The info or \c NULL if \e n is invalid. */
  CUnionInfo *UnionInfo (unsigned n) const;
  /** Get the n-th enumeration info.
   *  \param n The number of the info.
   *  \return The info or \c NULL if \e n is invalid. */
  CEnumInfo *EnumInfo (unsigned n) const;
  /** Get the n-th typedef info.
   *  \param n The number of the info.
   *  \return The info or \c NULL if \e n is invalid. */
  CTypedefInfo *TypedefInfo (unsigned n) const;
  /** Get the n-th function info.
   *  \param n The number of the info.
   *  \return The info or \c NULL if \e n is invalid. */
  CFunctionInfo *FunctionInfo (unsigned n) const;
  /** Get the n-th file info.
   *  \param n The number of the info.
   *  \return The info or \c NULL if \e n is invalid. */
  CFileInfo *FileInfo (unsigned n) const;

  /** Get the semantic object info identified by the given
   *  source code position. 
   *  \param pos The position in the source code. 
   *  \return The info or \c NULL if the info could not be identified. */
  CObjectInfo *ObjectInfo (Token *pos) const; 
  /** Get the semantic object info identified by the given
   *  source code position.
   *  \param pos The position in the source code. 
   *  \return The info or \c NULL if the info could not be identified. */
  CObjectInfo *ObjectInfo (CT_Token *pos) const; 

public:
  // Administration /////////////////////////////////////////////
  
  /** Insert a new semantic object into the database.
   *  \param info The semantic object info to insert. */
  void Insert (CObjectInfo *info);
  /** Remove the given semantic object from the database.
   *  \param info The semantic object info to remove. */
  void Remove (CObjectInfo *info);

  /** Dump the contents of the database. The dump is indented as
   *  tree corresponding to the nesting of the semantic objects.
   *  \param out The output stream to dump to.
   *  \param depth The max. depth in the tree to be dumped. */
  public: inline void __exec_old_Dump(::std::ostream & out,int depth) const;
void Dump (ostream &out, int depth = 0) const;

  /** Get the project info delivered to the constructor of the database. */
  CProject *Project () const;

private: 
  void Dump (ostream &, CStructure *, int, int) const;
  void DumpType (ostream &, CObjectInfo *, int) const;
  void DumpUsing (ostream &, CUsingInfo *, int) const;
  void DumpFunction (ostream &, CFunctionInfo *, int, int) const;
  void DumpAttribute (ostream &, CAttributeInfo *, int) const;
  void DumpNamespace (ostream &, CNamespaceInfo *, int) const;
  void DumpQualities (ostream &, CObjectInfo *) const;
  void DumpScopeName (ostream &, CStructure *) const;
  void DumpLocalScope (ostream &, CObjectInfo *, int) const;
  void DumpTemplateParam (ostream &, CTemplateParamInfo *, int) const;
  void indent (ostream &, int) const;

//  unsigned Infos (const char *, unsigned) const;
//  CObjectInfo *Info (const char *, unsigned, unsigned) const;
};

inline CClassDatabase::CClassDatabase (CProject &p, int size) :
  _Project (&p)
 {}

inline unsigned CClassDatabase::ObjectInfos () const
 { return ClassInfos () + UnionInfos () + EnumInfos () + 
          TypedefInfos () + FunctionInfos () + FileInfos (); }
inline unsigned CClassDatabase::ClassInfos () const
 { return _Classes.length (); }
inline unsigned CClassDatabase::UnionInfos () const
 { return _Unions.length (); }
inline unsigned CClassDatabase::EnumInfos () const
 { return _Enums.length (); }
inline unsigned CClassDatabase::TypedefInfos () const
 { return _Typedefs.length (); }
inline unsigned CClassDatabase::FunctionInfos () const
 { return _Functions.length (); }
inline unsigned CClassDatabase::FileInfos () const
 { return _Files.length (); }

inline CClassInfo *CClassDatabase::ClassInfo (unsigned i) const
 { return (CClassInfo*)_Classes.lookup (i); }
inline CUnionInfo *CClassDatabase::UnionInfo (unsigned i) const
 { return (CUnionInfo*)_Unions.lookup (i); }
inline CEnumInfo *CClassDatabase::EnumInfo (unsigned i) const
 { return (CEnumInfo*)_Enums.lookup (i); }
inline CTypedefInfo *CClassDatabase::TypedefInfo (unsigned i) const
 { return (CTypedefInfo*)_Typedefs.lookup (i); }
inline CFunctionInfo *CClassDatabase::FunctionInfo (unsigned i) const
 { return (CFunctionInfo*)_Functions.lookup (i); }
inline CFileInfo *CClassDatabase::FileInfo (unsigned i) const
 { return (CFileInfo*)_Files.lookup (i); }

inline CProject *CClassDatabase::Project () const
 { return _Project; }


} // namespace Puma

#endif /* __CClassDatabase_h__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CClassDatabase_h__

#ifdef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CClassDatabase_h__
/*** begin of aspect includes ***/
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#include "WinIfExists.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#include "WinImportHandler.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#include "WinMacros.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#include "CMatchSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#include "ExtGnu.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#include "ExtAC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__
#include "ExtACBuilderH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__
#include "ExtACBuilderCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#include "ExtACSyntaxH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__
#include "ExtACSyntaxCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#include "ExtACTree.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#include "ExtACKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__
#include "TraceSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#include "WinAsm.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#include "WinDeclSpecs.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#include "WinMemberExplSpec.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#include "WinTypeKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#include "PragmaOnceUnitState.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#include "PragmaOnce.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__
#include "CCExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__
#include "CCExprResolveCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__
#include "CExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__
#include "CExprResolveCC.ah"
#endif
/*** end of aspect includes ***/
#undef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#undef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CClassDatabase_h__
#endif // __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CClassDatabase_h__
