// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __smart_ptr_h__
#define __smart_ptr_h__

#include "Puma/RefCnt.h"

namespace Puma {


class SmartPtr {
  RefCnt *_data;

public:
  SmartPtr () : _data ((RefCnt*)0) {}
  ~SmartPtr () { clear (); }
  SmartPtr (const SmartPtr &copy);
  SmartPtr (RefCnt *rc) : _data (rc) {}
  SmartPtr &operator = (const SmartPtr &copy);

  void data (RefCnt *d);
  void clear ();
  RefCnt *data () const { return _data; }
  bool is_defined () const { return _data != (RefCnt*)0; }
};


} // namespace Puma

#endif /* __smart_ptr_h__ */
