// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CSourceInfo_h__
#define __CSourceInfo_h__

// stores source file information
// knows the file and the start token where an entity
// was declared in a program

namespace Puma {


class CFileInfo;
class CT_Token;
class Token;
class Unit;

class CSourceInfo {
  CFileInfo *_FileInfo; 
  CT_Token *_StartToken;

public: 
  CSourceInfo ();
  ~CSourceInfo ();
  
  bool operator ==(const CSourceInfo &) const;
  bool operator !=(const CSourceInfo &) const;
  bool operator <(const CSourceInfo &) const;
  bool operator >(const CSourceInfo &) const;
  bool operator <=(const CSourceInfo &) const;
  bool operator >=(const CSourceInfo &) const;

  bool operator ==(const CT_Token *) const;
  bool operator !=(const CT_Token *) const;
  bool operator <(const CT_Token *) const;
  bool operator >(const CT_Token *) const;
  bool operator <=(const CT_Token *) const;
  bool operator >=(const CT_Token *) const;

  bool operator ==(const Token *) const;

  // Get ...
  CFileInfo *FileInfo () const;
  CT_Token *StartToken () const;
  const char *FileName () const; // the file where it is located
  int Line () const;
  Unit *SrcUnit () const;

  // Set ... 
  void FileInfo (CFileInfo *);
  void StartToken (CT_Token *);
};

inline CSourceInfo::CSourceInfo () :
  _FileInfo ((CFileInfo*)0),
  _StartToken ((CT_Token*)0)
 {}
 
inline CSourceInfo::~CSourceInfo ()
 {}

inline bool CSourceInfo::operator !=(const CSourceInfo &info) const 
 { return ! (*this == info); }
inline bool CSourceInfo::operator <=(const CSourceInfo &info) const 
 { return ! (*this > info); }
inline bool CSourceInfo::operator >=(const CSourceInfo &info) const 
 { return ! (*this < info); }

inline bool CSourceInfo::operator !=(const CT_Token *token) const 
 { return ! (*this == token); }
inline bool CSourceInfo::operator <=(const CT_Token *token) const 
 { return ! (*this > token); }
inline bool CSourceInfo::operator >=(const CT_Token *token) const 
 { return ! (*this < token); }

inline CFileInfo *CSourceInfo::FileInfo () const
 { return _FileInfo; }
inline CT_Token *CSourceInfo::StartToken () const
 { return _StartToken; }

inline void CSourceInfo::FileInfo (CFileInfo *info)
 { _FileInfo = info; }
inline void CSourceInfo::StartToken (CT_Token *token)
 { _StartToken = token; }


} // namespace Puma

#endif /* __CSourceInfo_h__ */
