// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __bcstack_h__
#define __bcstack_h__

#include "Puma/BCList.h"

namespace Puma {

template <class Item, int BUCKET_SIZE = 32>
class BCStack : private BCList<Item, BUCKET_SIZE> {
  typedef BCList<Item, BUCKET_SIZE> List;
public:
  typedef typename List::Iterator Iterator;

private:
  Iterator _tos;
  long _length;
  
public:
  BCStack () : _length (0L) {}
  long length () const { return _length; }
  void push (Item item) {
    if (_tos != BCList<Item, BUCKET_SIZE>::end ())
      ++_tos;
    if (_tos == BCList<Item, BUCKET_SIZE>::end ()) 
      _tos = add (item);
    else
      *_tos = item;
    _length++;
  }
  Item &top () const { return *_tos; }
  void pop () { --_tos; _length--; }
  void reset () { List::reset (); _length = 0L; }
  bool empty () const { return _length == 0L; }
};

} // namespace Puma

#endif /* __bcstack_h__ */
