// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __IntroductionInfo_h__
#define __IntroductionInfo_h__

#include "Puma/Array.h"
#include "Puma/Printable.h"
#include "Puma/ACTree.h"
#include "Puma/CProtection.h"
#include "Puma/Unit.h"

using namespace Puma;

namespace Puma {
  class ACIntroductionInfo;
  class CT_AdviceDecl;
  class CObjectInfo;
} // namespace Puma

class AspectInfo;

class IntroductionInfo {
public:
  enum intro_type { INTRO_BASECLASS, INTRO_INHERITED, INTRO_OTHER,
    INTRO_SLICE_REF, INTRO_SLICE_DECL, INTRO_ERROR };
  
 private:
  AspectInfo *_aspect;
  ACIntroductionInfo *_acii;
  CT_AdviceDecl *_tree;
  intro_type _type;
  CProtection::Type _prot;
  Array<CObjectInfo*> _objs;
  Unit _pattern;
  
 public:

  IntroductionInfo (AspectInfo *ai, ACIntroductionInfo *acii);
  ACIntroductionInfo *ac_info () const { return _acii; }
  void print (ostream& os) const;
  CObjectInfo *object (int i) const { return _objs.lookup (i); }
  int objects () const { return _objs.length (); }
  intro_type type () const { return _type; }
  const char *type_str () const {
    switch (_type) {
    case INTRO_BASECLASS:  return "baseclass";
    case INTRO_INHERITED:  return "inherited";
    case INTRO_OTHER:      return "intro";
    case INTRO_SLICE_REF:  return "slice ref";
    case INTRO_SLICE_DECL: return "slice decl";
    case INTRO_ERROR:      return "error"; // Hm, shouldn't happen
    }
    return "error"; // just to suppress warnings
  }
  int line () const { return _tree->token ()->location ().line (); }
  int lines () const {
    return _tree->end_token ()->location ().line () - 
			 line () + 1;
  }
  const Unit &unit () const {
    return *(Unit*)_tree->token ()->belonging_to ();
  }
  CT_AdviceDecl *tree () const { return _tree; }
  CProtection::Type prot () const { return _prot; }
  AspectInfo *aspect () { return _aspect; }
  const Unit &pattern () const { return _pattern; }
};

#endif // __IntroductionInfo_h__
