// vs_passthrough.h                -*-c++-*-
//
//  A widget that by default passes focus and cursor handling through to
// a "currently focussed" widget.

#ifndef VS_PASSTHROUGH_H
#define VS_PASSTHROUGH_H

#include "vs_container.h"

class vs_passthrough:public vs_container
{
  void gained_focus();
  void lost_focus();

protected:
  virtual bool handle_char(chtype ch);

  // These call focussed() and unfocussed() on the result of get_focus().
  // (convenience methods)
  //
  // Provided to make it easier to manage focus simply.
  void defocus();
  void refocus();
public:
  vs_passthrough();

  // Returns the currently focussed widget, if any.
  virtual vscreen_widget *get_focus()=0;
  virtual void dispatch_mouse(short id, int x, int y, int z, mmask_t bstate);

  virtual bool focus_me();
  virtual bool get_cursorvisible();
  virtual point get_cursorloc();
};

#endif
