// vs_menubar.h   -*-c++-*-
//
//  Provides a horizontal menubar and a space for submenus.  This widget and
// its menus are superimposed on top of another widget.

#ifndef VS_MENUBAR_H
#define VS_MENUBAR_H

#include "vscreen_widget.h"
#include "vs_container.h"
#include "vs_menu.h"
#include "config/keybindings.h"

#include <string>
#include <vector>

class vs_menubar:public vs_container
{
  struct item
  {
    std::string title;
    vs_menu *menu;

    item(std::string _title, vs_menu *_menu)
      :title(_title), menu(_menu)
    {
    }
  };

  typedef std::vector<item> itemlist;
  typedef std::list<vscreen_widget *> activemenulist;

  // A list of the items in the menubar itself
  itemlist items;
  // A list of active menus
  activemenulist active_menus;

  // True if the menu-bar is visible and/or being used
  bool active;

  // True if the menu-bar should always be visible
  bool always_visible;

  itemlist::size_type curloc;

  // the widget underneath this one.
  vscreen_widget *subwidget;

  // Returns the starting X location of the given item in the menu
  int get_menustart(int idx);

  // Show/hide menus
  void show_menu(vs_menu *w);
  void hide_menu(vs_menu *w);

  void appear();
  void disappear();

  // Similar to the passthrough widget's routine (there's not enough
  // similarity, though, to justify making this a passthrough widget)
  vscreen_widget *get_focus();

  void got_focus();
  void lost_focus();
protected:
  virtual bool handle_char(chtype ch);
public:
  vs_menubar(bool _always_visible=true);
  ~vs_menubar();

  size size_request();
  void layout_me();

  void set_subwidget(vscreen_widget *w);

  void append_item(std::string title, vs_menu *menu);

  void show_all();

  // These aren't, unfortunately, particularly valid in this context. !!
  void add_widget(vscreen_widget *w) {abort();}
  void rem_widget(vscreen_widget *w) {abort();}

  virtual void paint();
  virtual bool focus_me();
  virtual void dispatch_mouse(short id, int x, int y, int z,
			      mmask_t bmask);

  bool get_cursorvisible();
  point get_cursorloc();

  bool get_always_visible() {return always_visible;}
  void set_always_visible(bool _always_visible);

  static keybindings *bindings;
  static void init_bindings();
};

#endif
