/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpClient {
    public static final int MAX_REDIRECTS = 20;

    public static void main(String[] args) throws Exception {
        if (args.length != 2 || !args[0].startsWith("http")) {
            System.out.println("Usage: HttpClient <url> <filename>");
            System.out.println();
            System.out.println("This program demonstrates how to download from java.net's");
            System.out.println("Documents & Files area using URLConnection");
            return;
        }
        File targetFile = new File(args[1]);
        if (targetFile.exists()) {
            System.out.println("Skipping " + args[0] + ", file already exists");
            return;
        }
        InputStream httpIn = HttpClient.getInputStream(args[0]);
        System.out.println("Downloading " + args[0]);
        BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(args[1]));
        HttpClient.pushStreams(httpIn, fileOut);
        ((OutputStream)fileOut).close();
    }

    private static void pushStreams(InputStream source, OutputStream target) throws IOException {
        int aByte;
        while ((aByte = source.read()) >= 0) {
            target.write(aByte);
        }
    }

    private static InputStream getInputStream(String url) throws IOException {
        ArrayList cookies = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
            urlConnection.setInstanceFollowRedirects(false);
            HttpClient.writeCookies(cookies, urlConnection);
            urlConnection.connect();
            if (urlConnection.getResponseCode() != 302 && urlConnection.getResponseCode() != 301) {
                return urlConnection.getInputStream();
            }
            url = urlConnection.getHeaderField("Location");
            HttpClient.acceptCookies(cookies, urlConnection);
        }
        throw new IOException("Max redirects 20 exceeded!");
    }

    private static void acceptCookies(List cookies, HttpURLConnection urlConnection) {
        Iterator<Map.Entry<String, List<String>>> i = urlConnection.getHeaderFields().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, List<String>> entry = i.next();
            String key = entry.getKey();
            if (!"Set-Cookie".equalsIgnoreCase(key)) continue;
            List<String> values = entry.getValue();
            Iterator<String> v = values.iterator();
            while (v.hasNext()) {
                String value = v.next();
                String cookie = value.split(";")[0];
                cookies.add(cookie);
            }
        }
    }

    private static void writeCookies(List cookies, HttpURLConnection urlConnection) {
        StringBuffer cookiesString = new StringBuffer();
        Iterator i = cookies.iterator();
        while (i.hasNext()) {
            if (cookiesString.length() > 0) {
                cookiesString.append("; ");
            }
            cookiesString.append(i.next());
        }
        if (cookiesString.length() > 0) {
            urlConnection.addRequestProperty("Cookie", cookiesString.toString());
        }
    }
}

